## Overview
- Objects are used in Cisco Management Center to define variables for policies, enhancing configuration management and analysis.
## Types of Objects

##### Network-Based Objects

- Represent IP addresses, networks, port/protocol pairs, VLAN tags, security zones, and geolocation (origin/destination country).
##### Reputation-Based Objects
- Security intelligence feeds and lists.
- Application filters based on category and reputation.
- File lists.
##### Non-Reputation-Based Objects
- URL categories.
##### Intrusion Policy Variable Sets
- Variables associated with intrusion policies.
##### Encrypted Traffic Handling Objects
- Includes cipher suites, public key certificates, paired private keys, and certificate distinguished names.

## Defining Objects

- Objects are referenced in various system configurations such as ACP, network analysis policies, intrusion policies, network discovery rules, event searches, reports, dashboards, etc.
- Use the object manager in the GUI to create and manage objects/groups.
- Objects can be created directly within policies like ACP.
- Editing objects used in policies requires reapplying the ACP.
- Objects in use cannot be deleted.

### Example:

- **Network Objects**:
    - DMZ_SERVER: Host IP 172.16.1.20
    - INSIDE_NETWORK: Subnet IP 10.10.2.0/24
- **Port Objects**:
    - FTP: tcp/21
    - HTTP: tcp/80
    - SSH: tcp/22

## Defining Object Groups

- Allows referencing multiple objects in a single configuration.
- Can group network, port, VLAN tag, URL, and PKI objects.
- Deleting a group removes associations, not the objects themselves.
- Cannot delete a group in use in an active policy.

### Example:

- **Port Object Group**: DMZ_SERVICE
    - FTP: tcp/21
    - HTTP: tcp/80
    - SSH: tcp/22
    - HTTPS: tcp/443

## Objects and Object Groups Use Case

- When configuring ACP rules, objects simplify matching criteria like source network, destination network, and destination port.
- Example ACP Rule:
    - Source Network: INSIDE_NETWORK (10.10.2.0/24)
    - Destination Network: DMZ_SERVER (172.16.1.20)
    - Destination Port: DMZ_SERVICE (FTP, HTTP, SSH)